/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient.brainsweep;

import at.petrak.hexcasting.common.recipe.ingredient.brainsweep.BrainsweepeeIngredient;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class VillagerIngredient
extends BrainsweepeeIngredient {
    @Nullable
    public final class_3852 profession;
    @Nullable
    public final class_3854 biome;
    public final int minLevel;

    public VillagerIngredient(@Nullable class_3852 profession, @Nullable class_3854 biome, int minLevel) {
        this.profession = profession;
        this.biome = biome;
        this.minLevel = minLevel;
    }

    @Override
    public boolean test(class_1297 entity, class_3218 level) {
        if (!(entity instanceof class_1646)) {
            return false;
        }
        class_1646 villager = (class_1646)entity;
        class_3850 data = villager.method_7231();
        return !(this.profession != null && !this.profession.equals((Object)data.method_16924()) || this.biome != null && !this.biome.equals(data.method_16919()) || this.minLevel > data.method_16925());
    }

    @Override
    public class_1297 exampleEntity(class_1937 level) {
        class_3854 biome = Objects.requireNonNullElse(this.biome, class_3854.field_17073);
        class_3852 profession = Objects.requireNonNullElse(this.profession, class_3852.field_17064);
        int tradeLevel = Math.min(this.minLevel, 1);
        class_1646 out = new class_1646(class_1299.field_6077, level);
        class_3850 data = out.method_7231();
        data.method_16921(profession).method_16922(biome).method_16920(tradeLevel);
        out.method_7195(data);
        class_2487 tag = new class_2487();
        out.method_5662(tag);
        return out;
    }

    @Override
    public List<class_2561> getTooltip(boolean advanced) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add(this.getName());
        if (advanced) {
            if (this.minLevel >= 5) {
                tooltip.add((class_2561)class_2561.method_43469((String)"hexcasting.tooltip.brainsweep.level", (Object[])new Object[]{5}).method_27692(class_124.field_1063));
            } else if (this.minLevel > 1) {
                tooltip.add((class_2561)class_2561.method_43469((String)"hexcasting.tooltip.brainsweep.min_level", (Object[])new Object[]{this.minLevel}).method_27692(class_124.field_1063));
            }
            if (this.biome != null) {
                tooltip.add((class_2561)class_2561.method_43470((String)this.biome.toString()).method_27692(class_124.field_1063));
            }
            if (this.profession != null) {
                tooltip.add((class_2561)class_2561.method_43470((String)this.profession.toString()).method_27692(class_124.field_1063));
            }
        }
        tooltip.add(BrainsweepeeIngredient.getModNameComponent(this.profession == null ? "minecraft" : class_7923.field_41195.method_10221((Object)this.profession).method_12836()));
        return tooltip;
    }

    @Override
    public class_2561 getName() {
        class_5250 component = class_2561.method_43470((String)"");
        boolean addedAny = false;
        if (this.minLevel >= 5) {
            component.method_10852((class_2561)class_2561.method_43471((String)"merchant.level.5"));
            addedAny = true;
        } else if (this.minLevel > 1) {
            component.method_10852((class_2561)class_2561.method_43471((String)("merchant.level." + this.minLevel)));
            addedAny = true;
        } else if (this.profession != null) {
            component.method_10852((class_2561)class_2561.method_43471((String)"merchant.level.1"));
            addedAny = true;
        }
        if (this.biome != null) {
            if (addedAny) {
                component.method_27693(" ");
            }
            class_2960 biomeLoc = class_7923.field_41194.method_10221((Object)this.biome);
            component.method_10852((class_2561)class_2561.method_43471((String)("biome." + biomeLoc.method_12836() + "." + biomeLoc.method_12832())));
            addedAny = true;
        }
        if (this.profession != null) {
            component.method_27693(" ");
            class_2960 professionLoc = class_7923.field_41195.method_10221((Object)this.profession);
            component.method_10852((class_2561)class_2561.method_43471((String)("entity.minecraft.villager." + professionLoc.method_12832())));
        } else {
            if (addedAny) {
                component.method_27693(" ");
            }
            component.method_10852(class_1299.field_6077.method_5897());
        }
        return component;
    }

    @Override
    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", BrainsweepeeIngredient.Type.VILLAGER.method_15434());
        if (this.profession != null) {
            obj.addProperty("profession", this.profession.toString());
        }
        if (this.biome != null) {
            obj.addProperty("biome", this.biome.toString());
        }
        obj.addProperty("minLevel", (Number)this.minLevel);
        return obj;
    }

    @Override
    public void write(class_2540 buf) {
        if (this.profession != null) {
            buf.method_10804(1);
            buf.method_10804(class_7923.field_41195.method_10206((Object)this.profession));
        } else {
            buf.method_10804(0);
        }
        if (this.biome != null) {
            buf.method_10804(1);
            buf.method_10804(class_7923.field_41194.method_10206((Object)this.biome));
        } else {
            buf.method_10804(0);
        }
        buf.writeInt(this.minLevel);
    }

    public static VillagerIngredient deserialize(JsonObject json) {
        class_3852 profession = null;
        if (json.has("profession") && !json.get("profession").isJsonNull()) {
            profession = (class_3852)class_7923.field_41195.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"profession")));
        }
        class_3854 biome = null;
        if (json.has("biome") && !json.get("biome").isJsonNull()) {
            biome = (class_3854)class_7923.field_41194.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"biome")));
        }
        int minLevel = class_3518.method_15260((JsonObject)json, (String)"minLevel");
        return new VillagerIngredient(profession, biome, minLevel);
    }

    public static VillagerIngredient read(class_2540 buf) {
        class_3852 profession = null;
        int hasProfession = buf.method_10816();
        if (hasProfession != 0) {
            profession = (class_3852)class_7923.field_41195.method_10200(buf.method_10816());
        }
        class_3854 biome = null;
        int hasBiome = buf.method_10816();
        if (hasBiome != 0) {
            biome = (class_3854)class_7923.field_41194.method_10200(buf.method_10816());
        }
        int minLevel = buf.readInt();
        return new VillagerIngredient(profession, biome, minLevel);
    }

    @Override
    public BrainsweepeeIngredient.Type ingrType() {
        return BrainsweepeeIngredient.Type.VILLAGER;
    }

    @Override
    public String getSomeKindOfReasonableIDForEmi() {
        StringBuilder bob = new StringBuilder();
        if (this.profession != null) {
            class_2960 profLoc = class_7923.field_41195.method_10221((Object)this.profession);
            bob.append(profLoc.method_12836()).append("//").append(profLoc.method_12832());
        } else {
            bob.append("null");
        }
        bob.append("_");
        if (this.biome != null) {
            class_2960 biomeLoc = class_7923.field_41194.method_10221((Object)this.biome);
            bob.append(biomeLoc.method_12836()).append("//").append(biomeLoc.method_12832());
        } else {
            bob.append("null");
        }
        bob.append(this.minLevel);
        return bob.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VillagerIngredient that = (VillagerIngredient)o;
        return this.minLevel == that.minLevel && Objects.equals(this.profession, that.profession) && Objects.equals(this.biome, that.biome);
    }

    public int hashCode() {
        return Objects.hash(this.profession, this.biome, this.minLevel);
    }
}

